/*
 * @(#)OMClassNameComparator.java  1.0  6. Februar 2004
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.oo.objectmodel;

import java.util.*;
/**
 * OMClassNameComparator compars {@link OMClass} objects by their name.
 * 
 * @author Werner Randelshofer
 * @version 1.0 6. Februar 2004  Created.
 */
public class OMClassNameComparator implements Comparator<OMClass> {
    
    /** Creates a new instance. */
    public OMClassNameComparator() {
    }
    
    public int compare(OMClass o1, OMClass o2) {
        return o1.getName().compareTo(o2.getName());
    }
    
    
}
